package util;

import java.io.File;


public class TreeWalker {

    public void walk ( TreeAction actor, File root )
    {
        if ( root.exists() ) {
            if ( root.isDirectory() ) {
                File[] files = root.listFiles();

                for ( int i=0 ; i<files.length ; ++i ) {
                    if ( files[i].isDirectory() ) {
                        this.walk( actor, files[i] );
                    }
                    else if ( files[i].isFile() ) {
                        actor.handle( files[i] );
                    }
                }
            }
            else if ( root.isFile() ) {
                actor.handle( root );
            }
        }
    }
}

//
// $Id: TreeWalker.java,v 1.3 2003/12/10 20:53:58 dwight Exp $
// Copyright 2003 Dwight Shih
//
