package hb;


public class Keyword {

    protected static final int unset_value = -1;

    protected int    id;
    protected String name;
    protected String info;

    /**
     * Default constructor
     */
    protected Keyword() {
        id          = unset_value;
        name        = null;
        info        = null;
    }

    /**
     */
    public Keyword(String newName) {
        id          = unset_value;
        name        = newName;
        info        = null;
    }

    /**
     * Get the Id value.
     * @return the Id value.
     */
    public int getId() {
        return id;
    }

    /**
     * Set the Id value.
     * @param newId The new Id value.
     */
    protected void setId(int newId) {
        this.id = newId;
    }

    /**
     * Get the Name value.
     * @return the Name value.
     */
    public String getName() {
        return name;
    }

    /**
     * Set the Name value.
     * @param newName The new Name value.
     */
    protected void setName(String newName) {
        this.name = newName;
    }

    /**
     * Gets the value of info
     * @return the value of info
     */
    public String getInfo()  {
        return this.info;
    }

    /**
     * Sets the value of info
     * @param argInfo Value to assign to this.info
     */
    public void setInfo(String argInfo) {
        this.info = argInfo;
    }

    /**
     * Hashcode generation
     */
    public int hashCode()
    {
        return ( this.name == null ) ? 0 : this.name.hashCode();
    }

    /**
     * Equality test
     * @param other The Object to be checked for equality
     */
    public boolean equals(Object other) {
        boolean equality = false;

        if ( this.getClass() == other.getClass() ) {
            Keyword otherWord = (Keyword) other;

            if ( this.id != unset_value && this.id == otherWord.id ) {
                equality = true;
            }
            else if ( this.name.equals( otherWord.name) ) {
                equality = true;
                if ( this.id == unset_value ) {
                    this.id = otherWord.id;
                }
                else if ( otherWord.id == unset_value ) {
                    otherWord.id = this.id;
                }
            }
        }

        return equality;
    }

    /**
     *
     */
    public String toString()
    {
        return new String ( id + ":" + name + "(" + info + ")" );
    }
}
//
// $Id: Keyword.java,v 1.8 2003/08/19 18:46:20 dwight Exp $
// Copyright 2003 Dwight Shih
//
