package hb;

import java.util.*;


public class KeySet
{
    protected static final int unset_value = -1;

    protected int    id;
    protected String name;
    protected String info;
    protected Set    keys;

    /**
     * Default constructor
     */
    protected KeySet()
    {
        id   = unset_value;
        name = null;
        info = null;
        keys = null;
    }

    /**
     */
    public KeySet( String newName )
    {
        id   = unset_value;
        name = newName;
        info = null;
        keys = null;
    }

    /**
     * Get the Id value.
     * @return the Id value.
     */
    public int getId() {
        return id;
    }

    /**
     * Set the Id value.
     * @param newId The new Id value.
     */
    protected void setId(int newId) {
        this.id = newId;
    }

    /**
     * Get the Name value.
     * @return the Name value.
     */
    public String getName() {
        return name;
    }

    /**
     * Set the Name value.
     * @param newName The new Name value.
     */
    public void setName(String newName) {
        this.name = newName;
    }

    /**
     * Get the Info value.
     * @return the Info value.
     */
    public String getInfo() {
        return info;
    }

    /**
     * Set the Info value.
     * @param newInfo The new Info value.
     */
    public void setInfo(String newInfo) {
        this.info = newInfo;
    }

    /**
     * Get the Keys value.
     * @return the Keys value.
     */
    public Set getKeys() {
        return keys;
    }

    /**
     * Set the Keys value.
     * @param newKeys The new Keys value.
     */
    public void setKeys(Set newKeys) {
        this.keys = newKeys;
    }

    /**
     * Add a Keyword to the Set
     * @param key The Keyword to be added.
     */
    public boolean add( Keyword key )
    {
        if ( keys == null ) { keys = new HashSet(); }
        return keys.add( key );
    }

    /**
     * Remove a Keyword from the set
     * @param key The Keyword to be removed
     */
    public boolean remove( Keyword key )
    {
        return (keys != null) ? keys.remove(key) : false;
    }

    /**
     *
     */
    public String toString()
    {
        return new String( "{" + id + ":" + name + "(" + info + ")|" + keys + "}" );
    }
}
//
// $Id: KeySet.java,v 1.3 2003/08/19 18:46:20 dwight Exp $
// Copyright 2003 Dwight Shih
//
