import java.util.List;
import java.util.Set;
import java.util.HashSet;

import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Session;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.HibernateException;

import hb.*;


public class Main {
   
    public static void main ( String[] args )
        throws MappingException,
               HibernateException
    {
        Configuration cfg = new Configuration();
        cfg.addClass( hb.Keyword.class );
        cfg.addClass( hb.KeySet.class );

        SessionFactory sessions = cfg.buildSessionFactory();
        Session session = sessions.openSession();

        Transaction tx = null;

        KeySet      ks = null;
        Keyword     kw = null;

        try {
            tx = session.beginTransaction();
            List existing = session.find( "from KeySet as ks where ks.name='colors'" );
            if ( ! existing.isEmpty() ) {
                ks = (KeySet) existing.get(0);
                System.out.println( "Read " + ks );
            }
            else {
                Set set = new HashSet();

                kw = new Keyword( "red" );
                session.save( kw );
                set.add( kw );

                kw = new Keyword( "blue" );
                session.save( kw );
                set.add( kw );

                ks = new KeySet( "colors" );
                ks.setKeys( set );
                session.save( ks );

                System.out.println( "Create " + ks );
            }
            tx.commit();
        }
        catch ( HibernateException he ) {
            if ( tx != null ) tx.rollback();
            throw he;
        }
        finally {
            session.close();
        }
    }
}
//
// $Id: Main.java,v 1.5 2003/08/19 18:47:02 dwight Exp $
// Copyright 2003 Dwight Shih
//
