import java.io.File;

import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.HibernateException;

import net.sf.hibern8ide.Hibern8IDE;

import util.*;


public class Ide {

    static class Action implements TreeAction {
        private Configuration config;

        public Action ( Configuration aConfig )
        {
            config = aConfig;
        }

        public void handle ( File f )
        {
            String name = f.toString();
            if ( name.endsWith( ".hbm.xml" ) ) {
                try {
                    config.addFile( f );
                } catch ( MappingException e ) {
                    throw new RuntimeException( e );
                }
            }
        }
    }

    public static void main ( String[] args )
        throws MappingException,
               HibernateException
    {
        Configuration cfg = new Configuration();
        Action      actor = new Action( cfg );
        TreeWalker walker = new TreeWalker();

        for ( int i=0 ; i<args.length ; ++i ) {
            File f = new File( args[i] );
            walker.walk( actor,f );
        }

        Hibern8IDE.startWith( cfg );
    }
}

//
// $Id: Ide.java,v 1.1 2003/12/09 22:50:25 dwight Exp $
// Copyright 2003 Dwight Shih
//
